@warnings
@version 2.8
@script channel
@name SK_ToggleValueCF

// ver.1.03 (2023/05/14)
// -バグ修正
//  valueOn, valueOff, combineModeが保存されていなかった
// -バージョンによって読み込みを変更
//  旧バージョンの保存ファイルでも正常に読み込めるようにした
//  今後のバージョンアップにも対応できるようにした
// 
// ver.1.02
// -スクリプトを区別するために@nameとdescriptionを変更
//  (新)SK_ToggleValueCF (旧)SK_ToggleValue
// -descriptionのスペース削除、@nameと同じに変更

@define AND_MODE 1
@define OR_MODE 2

@define N_OF_CONDITION 5
@define N_OF_FLAG 16

var description = "SK_ToggleValueCF";
var version = "1.03";

var valueOn = 0.0;
var valueOff = 1.0;

var combineMode = AND_MODE;

var objId = nil;
var flags = nil;

create: channel
{
    for(i = 1; i <= N_OF_CONDITION; i++)
    {
        objId[i] = nil;
        flags[i] = 0;
    }
    
    setdesc(description);
}

process: ca, frame, time
{
    switch(combineMode)
    {
        case 1:
            result = processAndMode(time);
            break;
        case 2:
            result = processOrMode(time);
            break;
    }
    
    ca.set(result);
}

processAndMode: time
{
    for(i = 1; i <= N_OF_CONDITION; i++)
    {
        if(objId[i] == nil) continue;
        
        obj = searchObject(objId[i]);
        
        if(obj)
        {
            chan = obj.firstChannel();
            v = round(chan.value(time), 0);
            
            if((flags[i] & (1 << v)) == false)
            {
                return(valueOff);
            }
        }
    }
    return(valueOn);
}

processOrMode: time
{
    for(i = 1; i <= N_OF_CONDITION; i++)
    {
        if(objId[i] == nil) continue;
        
        obj = searchObject(objId[i]);
        
        if(obj)
        {
            chan = obj.firstChannel();
            v = round(chan.value(time), 0);
            
            if((flags[i] & (1 << v)))
            {
                return(valueOn);
            }
        }
    }
    return(valueOff);
}

options
{
    var obj = nil;
    
    for(i = 1; i <= N_OF_CONDITION; i++)
    {
        obj[i] = searchObject(objId[i]);
    }
    
    reqbegin(description + " ver." + version);
    reqsize(600, 240);

    cValueOn = ctlnumber("Value On", valueOn);
    ctlposition(cValueOn, 10, 10);
    
    cValueOff = ctlnumber("Off", valueOff);
    ctlposition(cValueOff, 150, 10);
    
    cCombineMode = ctlchoice("Combine Mode", combineMode, @"AND", "OR"@, false);
    ctlposition(cCombineMode, 10, 40);
    
    cItem = nil;
    cFlag = nil;
    
    for(i = 1; i <= N_OF_CONDITION; i++)
    {
        y = 70 + (i - 1) * 25;
        cItem[i] = ctlmeshitems(string("#", i), obj[i]);
        ctlposition(cItem[i], 10, y, 200);
        
        for(j = 1; j <= N_OF_FLAG; j++)
        {
            x = 230 + (j - 1) * 20;
            cFlag[i * N_OF_FLAG + j] = ctlstate(string(j - 1), flags[i] & 1<<(j - 1), 20, "callback");
            ctlposition(cFlag[i * N_OF_FLAG + j], x, y);
        }
    }
    
    return if !reqpost();
    
    valueOn = getvalue(cValueOn);
    valueOff = getvalue(cValueOff);
    combineMode = getvalue(cCombineMode);
    
    for(i = 1; i <= N_OF_CONDITION; i++)
    {
        obj[i] = getvalue(cItem[i]);
    }
    
    for(i = 1; i <= N_OF_CONDITION; i++)
    {
        flags[i] = 0;
        
        for(j = 1; j <= N_OF_FLAG; j++)
        {
            flags[i] |= getvalue(cFlag[i * N_OF_FLAG + j]) ? 1<<(j - 1) : 0;
        }
    }
    
    for(i = 1; i <= N_OF_CONDITION; i++)
    {
        objId[i] = obj[i] ? obj[i].id : nil;
    }
    
    reqend();
}

callback: val
{
}

searchObject: id
{
    obj = Mesh();
    while(obj)
    {
        if (obj.id == id)
        {
            return(obj);
        }
        obj = obj.next();
    }
    return(nil);
}

load: what, io
{
    if (what == SCENEMODE)
    {
        ver = io.read().asStr();
        
        // バージョンごとに読み込みを変える
        if(ver == "1.03")
        {
            valueOn = io.read().asNum();
            valueOff = io.read().asNum();
            combineMode = io.read().asInt();
            for(i = 1; i <= N_OF_CONDITION; i++)
            {
                objId[i] = io.read().asInt();
                flags[i] = io.read().asInt();
            }
        }
        else
        {
            // バージョンが保存されていない場合
            
            objId[1] = ver.asInt();
            flags[1] = io.read().asInt();
            for(i = 2; i <= N_OF_CONDITION; i++)
            {
                objId[i] = io.read().asInt();
                flags[i] = io.read().asInt();
            }
        }
    }
}

save: what, io
{
    if (what == SCENEMODE)
    {
        // ver.1.03
        io.writeln(version.asStr());
        io.writeln(valueOn.asNum());
        io.writeln(valueOff.asNum());
        io.writeln(combineMode.asInt());
        for (i = 1; i <= N_OF_CONDITION; i++)
        {
            io.writeln(objId[i].asStr());
            io.writeln(flags[i].asStr());
        }
        
        // ver.1.02
        // for (i = 1; i <= N_OF_CONDITION; i++)
        // {
            // io.writeln(objId[i].asStr());
            // io.writeln(flags[i].asStr());
        // }
    }
}